<?php
namespace EdgeCore\CPT\Shortcodes\FullscreenScrollSlider;

use EdgeCore\Lib;

class FullscreenScrollSlider implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'edgtf_fullscreen_scroll_slider';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Edge Fullscreen Scroll Slider', 'edgtf-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by EDGE', 'edgtf-core' ),
					'icon'                      => 'icon-wpb-fullscreen-scroll-slider extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
					'params'                    => array(
                        array(
                            'type' => 'param_group',
                            'heading' => esc_html__( 'Items', 'edgtf-core' ),
                            'param_name' => 'items',
                            'params' => array(
                            	array(
                            	    'type'        => 'attach_image',
                            	    'param_name'  => 'image',
                            	    'heading'     => esc_html__( 'Image', 'edgtf-core' ),
                            	),
                                array(
                                    'type'        => 'textfield',
                                    'param_name'  => 'link',
                                    'heading'     => esc_html__( 'Link', 'edgtf-core' ),
                                    'admin_label' => true
                                ),
                            )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'show_nav',
                            'heading'     => esc_html__( 'Enable Bullets Navigation', 'eltdf-core' ),
                            'value'       => array_flip( haar_edge_get_yes_no_select_array( false ) ),
                            'admin_label' => true,
                        ),
                    )
				)
			);
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render($atts, $content = null) {
		$args = array(
            'items' => '',
            'show_nav' => '',
		);
		
		$params = shortcode_atts($args, $atts);
        $params['content'] = $content;
        $params['items'] = json_decode(urldecode($params['items']), true);

		$html = edgtf_core_get_shortcode_module_template_part('templates/fullscreen-scroll-slider-template', 'fullscreen-scroll-slider', '', $params);
		
		return $html;
	}
}